#define _CRT_DISABLE_PERFCRIT_LOCKS
#define ll long long
#define iPair pair<ll, ll>
#include <iostream>
#include <algorithm>
#include <cmath>
#include <set>
#include <vector>
using namespace std;

set<iPair> hull;


int findSide(iPair p1, iPair p2, iPair p)
{
    int val = (p.second - p1.second) * (p2.first - p1.first) - (p2.second - p1.second) * (p.first - p1.first);

    if (val > 0)
        return 1;
    if (val < 0)
        return -1;
    return 0;
}

int lineDist(iPair p1, iPair p2, iPair p)
{
    return abs((p.second - p1.second) * (p2.first - p1.first) -
        (p2.second - p1.second) * (p.first - p1.first));
}


void quickHull(vector<iPair> a, int n, iPair p1, iPair p2, int side)
{
    int ind = -1;
    int max_dist = 0;

    for (int i = 0; i < n; i++)
    {
        int temp = lineDist(p1, p2, a[i]);
        if (findSide(p1, p2, a[i]) == side && temp > max_dist)
        {
            ind = i;
            max_dist = temp;
        }
    }

    if (ind == -1)
    {
        hull.insert(p1);
        hull.insert(p2);
        return;
    }

    quickHull(a, n, a[ind], p1, -findSide(a[ind], p1, p2));
    quickHull(a, n, a[ind], p2, -findSide(a[ind], p2, p1));
}

vector<iPair> getHull(vector<iPair> a, int n)
{
    vector<iPair> res;
    if (n < 3)
    {
        return {};
    }

    int min_x = 0, max_x = 0;
    for (int i = 1; i < n; i++)
    {
        if (a[i].first < a[min_x].first)
            min_x = i;
        if (a[i].first > a[max_x].first)
            max_x = i;
    }

    quickHull(a, n, a[min_x], a[max_x], 1);

    quickHull(a, n, a[min_x], a[max_x], -1);

    while (!hull.empty())
    {
        res.push_back({ (*hull.begin()).first, (*hull.begin()).second });
        hull.erase(hull.begin());
    }

    return res;
}

ll pov(vector<pair<ll, ll>> points) {
    ll res = 0;
    for (unsigned i = 0; i < points.size(); i++) {
        pair<ll, ll> p = i ? points[i - 1] : points.back();
        pair<ll, ll> q = points[i];
        res += (p.first - q.first) * (p.second + q.second);
    }
    return fabs(res) / 2;
}


int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(0);

    vector<iPair> tacke;
    set<unsigned long long> resenja;
    ll brojTacki;

    cin >> brojTacki;

    for (int i = 0; i < brojTacki; i++)
    {
        ll t1, t2;
        cin >> t1 >> t2;
        tacke.push_back({t1, t2});
    }

    int n = tacke.size();
    vector<iPair> oHull = getHull(tacke, n);
    
    for (int i = 0; i < oHull.size(); i++)
    {
        vector<iPair> noveTacke;
        for (int j = 0; j < tacke.size(); j++)
        {
            if (oHull[i] != tacke[j]) noveTacke.push_back(tacke[j]);
        }
        
        vector<iPair> noviHull = getHull(noveTacke, noveTacke.size());
        unsigned long long povrsina = pov(noviHull);

        resenja.insert(povrsina);
    }
    cout << *resenja.begin() << endl;
}